<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CreatorStagesSteps
 *
 * @ORM\Table(name="creator_stages_steps")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\CreatorStagesStepsRepository")
 */
class CreatorStagesSteps
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"list","partsList","details"})
     */
    private $name;

    /**
     * @var integer $index
     *
     * @ORM\Column(name="step_index", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"partsList","details"})
     */
    private $index;

    /**
     * @var integer
     *
     * @ORM\Column(name="stage_id", type="integer")
     *
     */
    private $stageId;

    /**
     * @ORM\ManyToOne(targetEntity="CreatorStages",inversedBy="steps")
     * @ORM\JoinColumn(name="stage_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"partsList"})
     */
    private $stage;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return CreatorStagesSteps
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set stageId
     *
     * @param integer $stageId
     * @return CreatorStagesSteps
     */
    public function setStageId($stageId)
    {
        $this->stageId = $stageId;
    
        return $this;
    }

    /**
     * Get stageId
     *
     * @return integer 
     */
    public function getStageId()
    {
        return $this->stageId;
    }

    /**
     * Set stage
     *
     * @param \VM\ApiBundle\Entity\CreatorStages $stage
     * @return CreatorStagesSteps
     */
    public function setStage(\VM\ApiBundle\Entity\CreatorStages $stage = null)
    {
        $this->stage = $stage;
    
        return $this;
    }

    /**
     * Get stage
     *
     * @return \VM\ApiBundle\Entity\CreatorStages 
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->parts = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add parts
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesParts $parts
     * @return CreatorStagesSteps
     */
    public function addPart(\VM\ApiBundle\Entity\CreatorStagesParts $parts)
    {
        $this->parts[] = $parts;
    
        return $this;
    }

    /**
     * Remove parts
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesParts $parts
     */
    public function removePart(\VM\ApiBundle\Entity\CreatorStagesParts $parts)
    {
        $this->parts->removeElement($parts);
    }

    /**
     * Get parts
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getParts()
    {
        return $this->parts;
    }

    /**
     * Set index
     *
     * @param integer $index
     * @return CreatorStagesSteps
     */
    public function setIndex($index)
    {
        $this->index = $index;
    
        return $this;
    }

    /**
     * Get index
     *
     * @return integer 
     */
    public function getIndex()
    {
        return $this->index;
    }
}